import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServer.Args;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.TMultiplexedProcessor;

// import code generated by Apache Thrift compiler
import myservices.*;

public class MyMultiplexedServer {

    // define separate handlers and processors for both services
    public static Service1Handler handler1;
    public static Service1.Processor processor1;

    public static Service2Handler handler2;
    public static Service2.Processor processor2;

    public static void main(String [] args) {
        handler1 = new Service1Handler();
        processor1 = new Service1.Processor(handler1);

        handler2 = new Service2Handler();
        processor2 = new Service2.Processor(handler2);

        TMultiplexedProcessor mprocessor = new TMultiplexedProcessor();

        // register processors for both services with multiplexed processor
        // note the labels for both services
        mprocessor.registerProcessor("Service1", processor1);
        mprocessor.registerProcessor("Service2", processor2);

        // the rest is similar as for the single service
        Runnable server = new Runnable() {
            public void run() {
                myserver(mprocessor);
            }
        };

        new Thread(server).start();
    }

    public static void myserver(TMultiplexedProcessor processor) {
        TServerTransport serverTransport = new TServerSocket(8080);
        TServer server = new TThreadPoolServer(new TThreadPoolServer.Args(serverTransport).processor(processor));
        System.out.println("Starting multiplexed server on port 8080...");
        server.serve();
    }

}